package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

/**
 * StageReminder entity.
 * 
 */

public class StageRadiology extends StageEntity {

	// Fields
	private String radiologist;	
	private String requesting_provider;
	private String inpatient_outpatient;
	private String reason_for_study;
	private String clinical_history;
	private String performing_location_st_num;
	private String status;	
	private String reportText;	
	private String impressionText;	
	private Date examDate;
	private String examDateImprecise;
	private String procedureName;
	private String comments;
	private Date eventTime;
	private String eventTimeImprecise;
	
	// Constructors

	/**
	 * default constructor do not provide auto initialization since this class
	 * can be used in findByExample
	 */
	public StageRadiology() {
		super();
	}

	public String getRadiologist() {
		return radiologist;
	}

	public void setRadiologist(String radiologist) {
		this.radiologist = radiologist;
	}

	public String getRequesting_provider() {
		return requesting_provider;
	}

	public void setRequesting_provider(String requesting_provider) {
		this.requesting_provider = requesting_provider;
	}

	public String getInpatient_outpatient() {
		return inpatient_outpatient;
	}

	public void setInpatient_outpatient(String inpatient_outpatient) {
		this.inpatient_outpatient = inpatient_outpatient;
	}

	public String getReason_for_study() {
		return reason_for_study;
	}

	public void setReason_for_study(String reason_for_study) {
		this.reason_for_study = reason_for_study;
	}

	public String getClinical_history() {
		return clinical_history;
	}

	public void setClinical_history(String clinical_history) {
		this.clinical_history = clinical_history;
	}

	public String getPerforming_location_st_num() {
		return performing_location_st_num;
	}

	public void setPerforming_location_st_num(String performing_location_st_num) {
		this.performing_location_st_num = performing_location_st_num;
	}
		
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getReportText() {
		return reportText;
	}

	public void setReportText(String reportText) {
		this.reportText = reportText;
	}

	public String getImpressionText() {
		return impressionText;
	}

	public void setImpressionText(String impressionText) {
		this.impressionText = impressionText;
	}

	public Date getExamDate() {
		return examDate;
	}

	public void setExamDate(Date examDate) {
		this.examDate = examDate;
	}

	public String getProcedureName() {
		return procedureName;
	}

	public void setProcedureName(String procedureName) {
		this.procedureName = procedureName;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getEventTime() {
		return eventTime;
	}

	public void setEventTime(Date eventTime) {
		this.eventTime = eventTime;
	}

	public String getEventTimeImprecise() {
		return eventTimeImprecise;
	}

	public void setEventTimeImprecise(String eventTimeImprecise) {
		this.eventTimeImprecise = eventTimeImprecise;
	}

	public String toString() {
		return  "StageRadiology {" + 
				", id=" + getId() + 
				", oplock=" + oplock +
				", createdDate=" + createdDate + 
				", modifiedDate=" + modifiedDate + 
				", icn='" + icn + '\'' +
				", stationNumber='"	+ stationNumber + '\'' + 
				", requestMsgCtrlId=" + requestMsgCtrlId + 
				", responseMsgCtrlId=" + responseMsgCtrlId + 
				", extractStatus='" + extractStatus + '\'' + 
				", recordStatus='" + recordStatus + '\'' + 
				", Comments='" + comments + '\'' +
				", eventTime='" + eventTime + '\'' +
				", eventTimeImprecise='" + eventTimeImprecise + '\'' +
				'}';
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		result = String.valueOf(obj).equalsIgnoreCase(String.valueOf(this));
		return result;
	}

	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of immunization.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}

	public void setExamDateImprecise(String examDateImprecise) {
		this.examDateImprecise = examDateImprecise;
	}

	public String getExamDateImprecise() {
		return examDateImprecise;
	}

	public String toCompare() {
		return ""+getClinical_history()+
				StringUtils.deleteWhitespace(getComments())+
				getEventTime()+
				getExamDate()+
				getImpressionText()+
				getInpatient_outpatient()+
				getPerforming_location_st_num()+
				getProcedureName()+
				getRadiologist()+
				getReason_for_study()+
				StringUtils.deleteWhitespace(getReportText())+
				getRequesting_provider()+
				getStatus();
	}
}
